﻿/* Skript zur Demonstration von INSERT-Anweisungen
 * Als Benutzer SCOTT ausführen
 */
 

-- Einfache INSERT-Anweisung
insert into emp(empno, ename, job)
values (8000, 'MEIER', 'ANALYST');

select empno, ename, job, sal
  from emp
 where empno = 8000;
 
commit;

-- Komplexe INSERT-Anweisung mit Zeilenfunktionen und skalaren Abfragen
insert into emp
  (empno, ename, job, mgr, hiredate, sal, comm, deptno)
values
  (8001, 'MÜLLER', 'ANALYST',
   (select mgr
      from emp
     where job = 'ANALYST'
       and rownum = 1),
   trunc(sysdate), 
   (select trunc(avg(sal), -2)
      from emp
     where job = 'ANALYST'),
   null, 
   (select min(deptno)
      from emp
     where job = 'ANALYST'));
     
select *
  from emp
 where empno = 8001;
 
commit;

-- INSERT-Anweisung mit SELECT-Klausel
insert into emp
  (empno, ename, job, mgr, hiredate, sal, comm, deptno)
select empno + 1000, ename, job, mgr,
       trunc(sysdate), sal, comm, deptno
  from emp;
  
-- Abfrage auf die zentrale Sequenztabelle 
-- als Benutzer SYSTEM ausführen
select obj#, increment$, minvalue, maxvalue, cycle#, cache, highwater
  from sys.seq$;
  
-- Als Benutzer SCOTT ausführen:
-- Sequenz erzeugen und verwenden
create sequence emp_seq start with 8100;

insert into emp (empno, ename, sal)
values (emp_seq.nextval, 'SCHMITZ', 1200);

select *
  from emp
 where empno >= 8100;
 
rollback;
